function [nderivs] = bfor_endogenous_ms_solver_derivatives_numeric(derivs, Pmatss, vars, yss, xss, t1ss, THETA, nTHETA)
% 
% computes the numeric derivatives of the equilibrium conditions at the
%   steady state, for a specific parameter vector
%   
% Updated 2020/12
% Benigno, Foerster, Otrok, and Rebucci
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% 
% INPUTS
%  derivs   = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state  
%  Pmatss   = (ns x ns) matrix of with the steady state transition matrix
%  vars     = structure with elements that are variables of the system:
%       yvarsp, yvars, yvarss: non-predetermined variables
%       xvars, xvarslag, xvarss: pre-determined variables
%       epsp, eps: shocks
%       tvarsp, tvars: switching parameters
%  yss      = (ny x 1) vector of the steady state non-predetermined
%               variables
%  xss      = (nx x 1) vector of the steady state predetermined variables
%  t1ss     = (nt1 x 1) vector of the steady state perturbed switching
%               variables
%  THETA    = vector of parameters in symbolic form
%  nTHETA   = vector of parameters of numeric parameters to solve the model
% 
% 
% OUTPUTS
%  nderivs  = structure with elements of the first and second derivatives
%               of f with respect to vars, and first derivatives of Pmat
%               with respect to vars; both evaluated at steady state for
%               the given parameter vector nTHETA
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 


% -- Dimensions -- %
ne = length(vars.eps);
ns = length(Pmatss);
nt = length(vars.tvars);

% -- Regime Switching Parameters
thetas = zeros(nt,ns);
for s = 1:ns
    thetas(:,s) = double(subs(str2sym(strrep(string(vars.tvars),'_s',['_' num2str(s)])),THETA,nTHETA));
end

% -- First Order -- %
dfyp    = subs(derivs.dfyp,     [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfy     = subs(derivs.dfy,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfx     = subs(derivs.dfx,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxlag  = subs(derivs.dfxlag,	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfe     = subs(derivs.dfe,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dftp    = subs(derivs.dftp,     [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dft     = subs(derivs.dft,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);

% -- Second Order -- %
dfypyp      = subs(derivs.dfypyp,       [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfypy       = subs(derivs.dfypy,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfypx       = subs(derivs.dfypx,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfypxlag    = subs(derivs.dfypxlag,     [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfypep      = subs(derivs.dfypep,       [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfype       = subs(derivs.dfype,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfyptp      = subs(derivs.dfyptp,       [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfypt       = subs(derivs.dfypt,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfyy      	= subs(derivs.dfyy,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfyx      	= subs(derivs.dfyx,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfyxlag   	= subs(derivs.dfyxlag,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfye        = subs(derivs.dfye,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfytp       = subs(derivs.dfytp,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfyt        = subs(derivs.dfyt,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxx      	= subs(derivs.dfxx,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxxlag 	= subs(derivs.dfxxlag,      [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxe        = subs(derivs.dfxe,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxtp       = subs(derivs.dfxtp,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxt        = subs(derivs.dfxt,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxlagxlag	= subs(derivs.dfxlagxlag,	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxlage     = subs(derivs.dfxlage,   	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxlagtp    = subs(derivs.dfxlagtp,    	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfxlagt     = subs(derivs.dfxlagt,    	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfepep      = subs(derivs.dfepep,       [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfee        = subs(derivs.dfee,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfetp       = subs(derivs.dfetp,        [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dfet        = subs(derivs.dfet,         [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dftptp      = subs(derivs.dftptp,       [vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dftpt       = subs(derivs.dftpt,      	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);
dftt        = subs(derivs.dftt,      	[vars.yvarss;vars.xvarss;vars.t1varss;THETA], [yss;xss;t1ss;nTHETA]);

%-- Transition Matrix -- %
nderivs.dPy 	= double(subs(derivs.dPy,   [vars.yvarsp;vars.yvars;vars.xvars;vars.xlag;vars.epsp;vars.t1vars;THETA], [yss;yss;xss;xss;zeros(ne,1);t1ss;nTHETA]));

% -- Evaluating for each Regime -- %
for s = 1:ns
    for sp = 1:ns
        nderivs.dfyp{sp,s}          = double(subs(dfyp,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfy{sp,s}           = double(subs(dfy,          [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfx{sp,s}           = double(subs(dfx,          [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxlag{sp,s}        = double(subs(dfxlag,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfe{sp,s}           = double(subs(dfe,          [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dftp{sp,s}          = double(subs(dftp,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dft{sp,s}           = double(subs(dft,          [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypyp{sp,s}        = double(subs(dfypyp,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypy{sp,s}         = double(subs(dfypy,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypx{sp,s}         = double(subs(dfypx,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypxlag{sp,s}      = double(subs(dfypxlag,     [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypep{sp,s}        = double(subs(dfypep,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfype{sp,s}         = double(subs(dfype,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfyptp{sp,s}        = double(subs(dfyptp,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfypt{sp,s}         = double(subs(dfypt,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfyy{sp,s}          = double(subs(dfyy,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfyx{sp,s}          = double(subs(dfyx,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfyxlag{sp,s}       = double(subs(dfyxlag,      [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfye{sp,s}          = double(subs(dfye,     	[vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfytp{sp,s}         = double(subs(dfytp,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfyt{sp,s}          = double(subs(dfyt,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxx{sp,s}          = double(subs(dfxx,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxxlag{sp,s}       = double(subs(dfxxlag,      [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxe{sp,s}          = double(subs(dfxe,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxtp{sp,s}         = double(subs(dfxtp,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxt{sp,s}          = double(subs(dfxt,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxlagxlag{sp,s}    = double(subs(dfxlagxlag,   [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxlage{sp,s}       = double(subs(dfxlage,      [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxlagtp{sp,s}     	= double(subs(dfxlagtp,     [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfxlagt{sp,s}     	= double(subs(dfxlagt,      [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfepep{sp,s}        = double(subs(dfepep,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfee{sp,s}          = double(subs(dfee,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfetp{sp,s}     	= double(subs(dfetp,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dfet{sp,s}          = double(subs(dfet,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dftptp{sp,s}     	= double(subs(dftptp,       [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dftpt{sp,s}         = double(subs(dftpt,        [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
        nderivs.dftt{sp,s}          = double(subs(dftt,         [vars.tvarsp;vars.tvars],[thetas(:,sp);thetas(:,s)]));
    end
end